/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.bit.spider;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.standard.animation.controller.SpiderController;
import goblinbob.mobends.standard.data.SpiderData;
import net.minecraft.util.math.MathHelper;

public abstract class SpiderAnimationBitBase
extends AnimationBit<SpiderData> {
    protected float startTransition = 0.0f;

    protected void animateMovingLimb(SpiderData data, float groundLevel, float limbSwing, int index, float minDist, float maxDist, float minRot, float maxRot) {
        boolean odd = index % 2 == 1;
        float offset = (index + 1) / 2 % 2 == 0 ? (float)Math.PI : 0.0f;
        float smoothness = 1.0f;
        float sideRotation = minRot + (MathHelper.func_76126_a((float)(limbSwing + offset)) * 0.5f + 0.5f) * (maxRot - minRot);
        float dist = minDist + (MathHelper.func_76126_a((float)(limbSwing + offset)) * 0.5f + 0.5f) * (maxDist - minDist);
        groundLevel += -7.0f + Math.max(0.0f, MathHelper.func_76134_b((float)(limbSwing + offset))) * 4.0f;
        SpiderData.Limb limb = data.limbs[index];
        limb.upperPart.rotation.setSmoothness(smoothness).orientY(odd ? sideRotation : -sideRotation);
        if (this.startTransition >= 1.0f) {
            SpiderController.putLimbOnGround(limb.upperPart.rotation, limb.lowerPart.rotation, odd, dist, groundLevel);
        } else {
            SpiderController.putLimbOnGround(limb.upperPart.rotation, limb.lowerPart.rotation, odd, dist, groundLevel, this.startTransition);
        }
        limb.setAngleAndDistance(odd ? sideRotation / 180.0f * (float)Math.PI : (float)Math.PI - sideRotation / 180.0f * (float)Math.PI, dist * 0.0625f);
    }
}

